﻿using TravelDataLib;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;

namespace TravelDataLibTests
{
  [TestClass()]
  public class TravelRequestDataAccessTest
  {

    private TestContext testContextInstance;

    public TestContext TestContext
    {
      get
      {
        return testContextInstance;
      }
      set
      {
        testContextInstance = value;
      }
    }

    #region Additional test attributes
    // 
    //You can use the following additional attributes as you write your tests:
    //
    //Use ClassInitialize to run code before running the first test in the class
    //[ClassInitialize()]
    //public static void MyClassInitialize(TestContext testContext)
    //{
    //}
    //
    //Use ClassCleanup to run code after all tests in a class have run
    //[ClassCleanup()]
    //public static void MyClassCleanup()
    //{
    //}
    //
    //Use TestInitialize to run code before running each test
    //[TestInitialize()]
    //public void MyTestInitialize()
    //{
    //}
    //
    //Use TestCleanup to run code after each test has run
    //[TestCleanup()]
    //public void MyTestCleanup()
    //{
    //}
    //
    #endregion

    [TestMethod()]
    public void SaveTest()
    {
      TravelRequestMsg request = new TravelRequestMsg();
      request.Id = "54bdaf1e-1807-4ff9-a67c-cc1fba3a825f";
      request.IsApproved = false;
      request.Justification = "Chcę podróżować.";
      request.Name = "Zgłoszenie";
      request.RequesterId = "jkowal";
      request.TravelEstimate = 1234;
      request.VendorReservationId = Guid.NewGuid().ToString();
      request.WorkflowInstanceId = Guid.NewGuid().ToString();
      request.CreationDate = DateTime.Now;
      request.ApprovalManagerId = "managerId";

      TravelRequestDataAccess.Save(request);

    }

    [TestMethod()]
    public void CompleteTest()
    {
      TravelRequestMsg request = new TravelRequestMsg();
      request.Id = "09e43d36-4649-4fc6-b6ae-d718b8b53999";
      request.IsApproved = true;
      request.ApprovalManagerId = "managerId";

      TravelRequestDataAccess.Complete(request);
    }


  }
}
